// Name: Nafis islam
// ID: 233014239
// course title: Structured Programming
// course code: CSE 1201
// section: 01

#include <stdio.h>
#include <string.h>

#define MAX_STUDENTS 20

// Structure to store student details
struct Student {
    int id;
    char name[50];
    int age;
    char address[100];
};

int main() {
    struct Student students[MAX_STUDENTS];
    int numStudents = 0, i, searchID;
    int found = 0;

    // Storing student details
    printf("Enter student details (up to %d students):\n", MAX_STUDENTS);
    while (numStudents < MAX_STUDENTS) {
        printf("\nStudent %d:\n", numStudents + 1);
        printf("ID: ");
        scanf("%d", &students[numStudents].id);
        printf("Name: ");
        scanf(" %[^\n]s", students[numStudents].name);
        printf("Age: ");
        scanf("%d", &students[numStudents].age);
        printf("Address: ");
        scanf(" %[^\n]s", students[numStudents].address);

        // Validate age
        if (students[numStudents].age < 18 || students[numStudents].age > 24) {
            printf("Error: Age must be between 18 and 24.\n");
            continue;
        }

        numStudents++;
        printf("Student added successfully.\n");

        if (numStudents == MAX_STUDENTS) {
            printf("\nMaximum number of students reached.\n");
            break;
        }
    }

    // Display student details by ID
    printf("\nEnter the ID of the student to display details: ");
    scanf("%d", &searchID);

    for (i = 0; i < numStudents; i++) {
        if (students[i].id == searchID) {
            printf("\nStudent Details:\n");
            printf("ID: %d\n", students[i].id);
            printf("Name: %s\n", students[i].name);
            printf("Age: %d\n", students[i].age);
            printf("Address: %s\n", students[i].address);
            found = 1;
            break;
        }
    }

    if (!found) {
        printf("\nStudent with ID %d not found.\n", searchID);
    }

    return 0;
}
